#version 120 

varying vec4 frontColor;
varying vec4 fogColor;
varying float fragAlpha;
varying float gamma_i;

uniform sampler2D tex0;
uniform sampler2D tex1;
uniform vec2 map_siz_inv;

void main ()
{
	// get texture 1 color
	vec4 texval1 = texture2D(tex0, gl_TexCoord[0].st); 
	// get light map - texture 2 color
	vec4 texval2 = texture2D(tex1, gl_FragCoord.xy * map_siz_inv); 
   
	// compute lightness 
	float lig = texval1.r + texval1.g + texval1.b; 
	lig *= 0.3333333333;
   
	// apply less contrast
//	lig -= 0.5;
//	lig *= 0.44;
//	lig += 0.5;
   
	// prepare inverted alpha of vertex color
	float a_inv = 1.0 - fogColor.a;
   
	// calculate result color
	texval1.r = texval1.r * a_inv + fogColor.r * lig * fogColor.a;
	texval1.g = texval1.g * a_inv + fogColor.g * lig * fogColor.a;
	texval1.b = texval1.b * a_inv + fogColor.b * lig * fogColor.a;
   
    if(gamma_i == 1.0)
    {
        // mix color with lightmap
        gl_FragColor = texval1 * vec4(texval2.rgb, fragAlpha * frontColor.a);
    }
    else
    {
        texval1 = texval1 * vec4(texval2.rgb, fragAlpha * frontColor.a);
        gl_FragColor = vec4( pow(texval1.rgb, vec3(gamma_i)), texval1.a);
    }
}
